" Unit 4 - Lecture 2 "
"------------------------------------------------------------------------"

"
Understanding Output Of Logistic Regression
"


model = glm(am ~ wt,
            family = binomial(link = "logit"),
            data = mtcars)

model$fitted.values
summary(model)



"------------------------------------------------------------------------"

"
Confidence Interval For Mean / Individual Response
"

# Syntax:
predict(<model>,newdata = <data>,
        interval = "<prediction / confidence>")


model = lm(mpg ~ wt + qsec,mtcars)

predict(model,newdata = data.frame(wt = c(3.5,4),
                                   qsec = c(3,4)),
        interval = "confidence")

predict(model,newdata = data.frame(wt = c(3.5,4),
                                   qsec = c(3,4)),
        interval = "prediction")

"------------------------------------------------------------------------"

"
Using step() for Forward and Backward selection
"

# Forward Selection:

model0 = lm(mpg ~ 1,mtcars)
model.full = lm(mpg ~ .,mtcars)

model = step(model0,
             direction = "forward",
             scope = list(lower = model0,
                          upper = model.full))


model = step(model.full,
             direction = "backward",
             scope = list(lower = model0,
                          upper = model.full))

"------------------------------------------------------------------------"

"
ANOVA Test To Compare Simple and Complex Model

H0: Simple model is better
H1: Complex model is better

"

# Syntax:
anova(<simple model> , <complex model>)

model.s = glm(mpg ~ wt,
              data = mtcars,
              family = Gamma)

model.c = glm(mpg ~ wt + qsec,
              data = mtcars,
              family = Gamma)

anova(model.s,model.c,test = "F")


"------------------------------------------------------------------------"

" Adding Interaction Effect "

model = lm(Sepal.Length ~ Petal.Length + Petal.Width,iris)
summary(model)

model = lm(Sepal.Length ~ Petal.Length + Petal.Width +
             Petal.Length:Petal.Width,iris)


model = lm(Sepal.Length ~ Petal.Length * Petal.Width,iris)

summary(model)

"Shortcut:

A * B = A + B + A:B

A:B is the interaction effect between A and B

A * B * C = A + B + C + A:B + B:C + A:C + A:B:C

"


"------------------------------------------------------------------------"

"
Gist of PCA
"

"------------------------------------------------------------------------"
"
Exam Questions - Regression Analysis

"
"------------------------------------------------------------------------"

"a."
"
Xi ~ N(132,sigma = 12.32)
X_bar ~ N(132,sigma = 12.32 / sqrt(20))
"

mu = 132
sigma = 12.32

"b."

set.seed(1947)
X = rnorm(20,mu,sigma)

"c."

KDE = density(X)
Mode = KDE$x[which.max(KDE$y)]


"d."

Mode = c()

set.seed(1947)

for(i in 1:10000){
  
  X = rnorm(20,mu,sigma)
  
  KDE = density(X)
  Mode[i] = KDE$x[which.max(KDE$y)]
  
}


"e."

hist(Mode,freq = F,
     ylim = c(0,0.15))

"f."

lines(seq(100,160,0.5),
      dnorm(seq(100,160,0.5),
            mu,sigma / sqrt(20)),
      col = "red")

"g."

qqnorm(Mode) ; qqline(Mode,col = "red")

abline(0,1,col = "blue")

"Extra"

X = rnorm(1000,5,1)
Y = qnorm(runif(1000),5,1)

qqplot(X,Y) ; abline(0,1,col = "red")
qqplot(X,Y) ; qqline(X,col = "red")


